#!/bin/bash
ref="/ptmp/LAS/arnstrm/shujun/mexicana/zmexicana.fa"
window=$1
cpus=$SLURM_JOB_CPUS_PER_NODE
suff=$(echo $window |sed 's/:/_/g')
out="mexicana.v1_${suff}.vcf"

donefile=hc_${suff}.done


ml purge
ml jdk
jarfile="$HOME/bin/gatk-package-4.2.2.0-local.jar"
if [ ! -f ${donefile} ]; then
java -Xmx60g -Djava.io.tmpdir=$TMPDIR -jar ${jarfile} HaplotypeCaller --reference $ref -I 1209-MAIZE-PE-AD002-1_S1_001_final2.bam -I 1487-1_S4_L001_001_final2.bam -I 1487-1_S4_L002_001_final2.bam -I 1487-1_S4_L003_001_final2.bam -I 1487-1_S4_L004_001_final2.bam -I 1487-2_S2_L001_001_final2.bam -I 1487-2_S2_L002_001_final2.bam -I 1487-2_S2_L003_001_final2.bam -I 1487-2_S2_L004_001_final2.bam -I 1487-3_S1_L001_001_final2.bam -I 1487-3_S1_L002_001_final2.bam -I 1487-3_S1_L003_001_final2.bam -I 1487-3_S1_L004_001_final2.bam -I 1487-4_S3_L001_001_final2.bam -I 1487-4_S3_L002_001_final2.bam -I 1487-4_S3_L003_001_final2.bam -I 1487-4_S3_L004_001_final2.bam -I 1506-1_S1_L001_001_final2.bam -I 1506-1_S1_L002_001_final2.bam -I 1506-1_S1_L003_001_final2.bam -I 1506-1_S1_L004_001_final2.bam -I 1507-1_S1_L001_001_final2.bam -I 1507-1_S1_L002_001_final2.bam -I 1507-1_S1_L003_001_final2.bam -I 1507-1_S1_L004_001_final2.bam -I 1508-1_S1_L001_001_final2.bam -I 1508-1_S1_L002_001_final2.bam -I 1508-1_S1_L003_001_final2.bam -I 1508-1_S1_L004_001_final2.bam -I 1605-1_S1_L001_001_final2.bam -I 1605-1_S1_L002_001_final2.bam -I 1605-1_S1_L003_001_final2.bam -I 1605-1_S1_L004_001_final2.bam -I 1721-1_S1_L001_001_final2.bam -I 1721-1_S1_L002_001_final2.bam -I 1721-1_S1_L003_001_final2.bam -I 1721-1_S1_L004_001_final2.bam -I 1721-2_S1_L001_001_final2.bam -I 1721-2_S1_L002_001_final2.bam -I 1721-2_S1_L003_001_final2.bam -I 1721-2_S1_L004_001_final2.bam -I 1721-5_S1_L001_001_final2.bam -I 1721-5_S1_L002_001_final2.bam -I 1721-5_S1_L003_001_final2.bam -I 1721-5_S1_L004_001_final2.bam -I 1726_Hp301_S0_001_final2.bam -I 1726-Oh7B_S1_L001_001_final2.bam -I 1726-Oh7B_S1_L002_001_final2.bam -I 1726-Oh7B_S1_L003_001_final2.bam -I 1726-Oh7B_S1_L004_001_final2.bam -I 2025-B73_S1_L001_001_final2.bam -I 2025-B73_S1_L002_001_final2.bam -I 2025-B73_S1_L003_001_final2.bam -I 2025-B73_S1_L004_001_final2.bam -I 2025_Ki11_final2.bam -I 2025-NC350_S1_L001_001_final2.bam -I 2025-NC350_S1_L002_001_final2.bam -I 2025-NC350_S1_L003_001_final2.bam -I 2025-NC350_S1_L004_001_final2.bam -I AB10_S0_001_final2.bam -I CML103-1_S1_L001_001_final2.bam -I CML103-1_S1_L002_001_final2.bam -I CML103-1_S1_L003_001_final2.bam -I CML103-1_S1_L004_001_final2.bam -I CML333_S0_L001_001_final2.bam -I CML333_S0_L002_001_final2.bam -I CML333_S0_L003_001_final2.bam -I CML333_S0_L004_001_final2.bam -I Ki3-1626_S1_L001_001_final2.bam -I Ki3-1626_S1_L002_001_final2.bam -I Ki3-1626_S1_L003_001_final2.bam -I Ki3-1626_S1_L004_001_final2.bam -I M162W_S0_001_final2.bam -I Maize-10X-1_S4_L001_001_final2.bam -I Maize-10X-1_S4_L002_001_final2.bam -I Maize-10X-1_S4_L003_001_final2.bam -I Maize-10X-1_S4_L004_001_final2.bam -I Maize-10X-2_S2_L001_001_final2.bam -I Maize-10X-2_S2_L002_001_final2.bam -I Maize-10X-2_S2_L003_001_final2.bam -I Maize-10X-2_S2_L004_001_final2.bam -I Maize-10X-3_S3_L001_001_final2.bam -I Maize-10X-3_S3_L002_001_final2.bam -I Maize-10X-3_S3_L003_001_final2.bam -I Maize-10X-3_S3_L004_001_final2.bam -I Maize-10X-4_S1_L001_001_final2.bam -I Maize-10X-4_S1_L002_001_final2.bam -I Maize-10X-4_S1_L003_001_final2.bam -I Maize-10X-4_S1_L004_001_final2.bam -I Mo18W_S1_001_final2.bam -I MS37W_S0_001_final2.bam -I MS71-1797_S1_L001_001_final2.bam -I MS71-1797_S1_L002_001_final2.bam -I MS71-1797_S1_L003_001_final2.bam -I MS71-1797_S1_L004_001_final2.bam -I NC358_S0_001_final2.bam -I OH43-1721_S1_L001_001_final2.bam -I OH43-1721_S1_L002_001_final2.bam -I OH43-1721_S1_L003_001_final2.bam -I OH43-1721_S1_L004_001_final2.bam -I P39-1927_S1_L001_001_final2.bam -I P39-1927_S1_L002_001_final2.bam -I P39-1927_S1_L003_001_final2.bam -I P39-1927_S1_L004_001_final2.bam -I Tx303-1927_S1_L001_001_final2.bam -I Tx303-1927_S1_L002_001_final2.bam -I Tx303-1927_S1_L003_001_final2.bam -I Tx303-1927_S1_L004_001_final2.bam -I Tzi8_S0_L001_001_final2.bam -I Tzi8_S0_L002_001_final2.bam -I Tzi8_S0_L003_001_final2.bam -I Tzi8_S0_L004_001_final2.bam -I Tzi8_S1_L001_001_final2.bam -I Tzi8_S1_L002_001_final2.bam -I Tzi8_S1_L003_001_final2.bam -I Tzi8_S1_L004_001_final2.bam -L $window -O $out || {
echo >&2 ERROR: gatk failed for $window
exit 1
}
fi
touch $donefile

